'--------------------------------------------------------------
'                     (c) 1999-2002 MCS Electronics
'--------------------------------------------------------------
'  file: I2C.BAS
'  demo: I2CSEND and I2CRECEIVE
'--------------------------------------------------------------
$baud = 9600
$crystal = 8000000
Config Scl = Portc.0
Config Sda = Portc.1
Declare Sub Write_eeprom(byval Adres As Byte , Byval Value As Byte)
Declare Sub Read_eeprom(byval Adres As Byte , Value As Byte)

Const Addressw = 162                                        'slave write address
Const Addressr = 163                                        'slave read address

Dim B As Byte , Adres As Byte , Value As Byte               'dim byte
Dim H As Byte , L As Byte , I As Byte
For I = 2 To 6
'Call Write_eeprom(i , 0)
Next I
Print "Test Real Time Clock with PCF8583"
Print "format ->hh:mm:ss   ->dd/mm/y"

Do
Call Read_eeprom(4 , Value) : Value = Value And &B00111111
Print "       ->" ; : Print Bcd(value) ; ":" ;              'read it back
Call Read_eeprom(3 , Value) : Print Bcd(value) ; ":" ;      'read it back
Call Read_eeprom(2 , Value) : Print Bcd(value) ; " " ;
Call Read_eeprom(5 , Value) : B = Value : Value = Value And &B00111111
Print "  ->" ; Bcd(value) ; "/" ;
Call Read_eeprom(6 , Value) : Value = Value And &B00011111 : Print Bcd(value) ; "/" ;
Shift B , Right , 6 : Print Bcd(b) ;

!ldi  r16,13
!out udr,r16
Waitms 200
Loop                                                        'Until I = 27
End

'sample of writing a byte to EEPROM AT2404
Sub Write_eeprom(byval Adres As Byte , Byval Value As Byte)
    I2cstart                                                'start condition
    I2cwbyte Addressw                                       'slave address
    I2cwbyte Adres                                          'asdress of EEPROM
    I2cwbyte Value                                          'value to write
    I2cstop                                                 'stop condition
    Waitms 10                                               'wait for 10 milliseconds
End Sub

Sub Read_eeprom(byval Adres As Byte , Value As Byte)
   I2cstart                                                 'generate start
   I2cwbyte Addressw                                        'slave adsress
   I2cwbyte Adres                                           'address of EEPROM
   I2cstart                                                 'repeated start
   I2cwbyte Addressr                                        'slave address (read)
   I2crbyte Value , Nack                                    'read byte
   I2cstop                                                  'generate stop
End Sub